<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2006-2007 Queplix Corp.
  ~
  ~ Licensed under the Queplix Public License, Version 1.1.1 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
  ~ License for the specific language governing permissions and limitations under
  ~ the License.
  -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output indent="yes"/>
	<xsl:template match="*">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="entity-config">
		<xsl:copy>
			<xsl:for-each select="@*">
				<xsl:copy-of select="."/>
			</xsl:for-each>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="entity">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:variable name="full_name">
					<xsl:for-each select="ancestor::entity/@name">
						<xsl:value-of select="concat(., '.')"/>
					</xsl:for-each>
					<xsl:value-of select="@name"/>
				</xsl:variable>
				<xsl:copy-of select="$full_name"/>
			</xsl:attribute>
			<xsl:for-each select="ancestor-or-self::entity">
				<xsl:copy-of select="@*[name()!='name']"/>
			</xsl:for-each>
			<xsl:apply-templates select="metainf|efield|dataset"/>
			<xsl:variable name="eql-constraint" select="ancestor-or-self::entity/eql-constraint"/>
			<xsl:copy-of select="$eql-constraint[last()]"/>
			<xsl:variable name="eql-where" select="ancestor-or-self::entity/eql-where"/>
			<xsl:copy-of select="$eql-where[last()]"/>
			<xsl:variable name="eql-order" select="ancestor-or-self::entity/eql-order"/>
			<xsl:copy-of select="$eql-order[last()]"/>
			<xsl:variable name="fkeys" select="ancestor-or-self::entity/fkeys"/>
			<xsl:copy-of select="$fkeys"/>
			<xsl:copy-of select="scripts"/>
		</xsl:copy>
		<xsl:apply-templates select="entity"/>
	</xsl:template>
	<xsl:template match="metainf">
		<xsl:copy>
			<xsl:for-each select="@*">
				<xsl:copy-of select="."/>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="efield">
		<xsl:copy>
			<xsl:variable name="element" select="name()"/>
			<xsl:variable name="name" select="@name"/>
			<xsl:for-each select="ancestor-or-self::*/*[name() = $element and @name = $name]">
				<xsl:copy-of select="@*"/>
			</xsl:for-each>
			<xsl:variable name="refs" select="ancestor-or-self::*/*[name() = $element and @name = $name]/ref"/>
			<xsl:copy-of select="$refs[last()]"/>
			<xsl:variable name="listref" select="ancestor-or-self::*/*[name() = $element and @name = $name]/listref"/>
			<xsl:copy-of select="$listref[last()]"/>
			<xsl:variable name="eqlsrc" select="ancestor-or-self::*/*[name() = $element and @name = $name]/eql-src"/>
			<xsl:copy-of select="$eqlsrc[last()]"/>
			<xsl:variable name="eqldefsrc" select="ancestor-or-self::*/*[name() = $element and @name = $name]/eql-defsrc"/>
			<xsl:copy-of select="$eqldefsrc[last()]"/>
			<xsl:variable name="eqlextsrchfunc" select="ancestor-or-self::*/*[name() = $element and @name = $name]/eqlext-srchfunc"/>
			<xsl:copy-of select="$eqlextsrchfunc[last()]"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="dataset">
		<xsl:copy>
			<xsl:variable name="element" select="name()"/>
			<xsl:variable name="name" select="@name"/>
			<xsl:for-each select="ancestor-or-self::*/*[name() = $element and @name = $name]">
				<xsl:copy-of select="@*"/>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
