<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2006-2007 Queplix Corp.
  ~
  ~ Licensed under the Queplix Public License, Version 1.1.1 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
  ~ License for the specific language governing permissions and limitations under
  ~ the License.
  -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" indent="yes"/>

	<xsl:template match="//history">
		<html>
                    <head>
			<link rel="stylesheet" href="Core.css" type="text/css"/>
                    </head>
                    <body>
			<xsl:apply-templates/>
                    </body>
		</html>
	</xsl:template>

	<xsl:template match="//history-topic">
		<table border="0" cellspacing="1" class="gridTable" width="100%" style="font-size:12px; font-family:Arial;">
			<xsl:apply-templates select="history-header"/>
			<xsl:apply-templates select="history-data/history-field"/>
		</table>		
		<xsl:apply-templates select="ifg-data/ifg"/>
		<br/>
	</xsl:template>

	<xsl:template match="//history-header">
		<tr class="headerRow">
			<td align="center" colspan="3" style="font-size:13px; font-weight:bold;">&#160;
				<xsl:value-of select="concat(@user_fullname, ' (', @user_id, ') ')"/>
				<br/>
				<xsl:value-of select="@timestamp"/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="//ifg">
			<center><span  style="font-size:13px; font-weight:bold;font-family:Arial;">&#160;
				<xsl:value-of select="./@caption"/>
			</span>
			</center>
			<xsl:apply-templates select="ifg-record"/>
			
	</xsl:template>
	
	<xsl:template match="//ifg-record">
		<xsl:variable name="record-action" select="./@action"/>
		<center>
		<span  style="font-size:13px; font-weight:bold;font-family:Arial;">&#160;
				<xsl:text>The record with </xsl:text>
				<xsl:for-each select="./pkey-field">
					<xsl:choose>
						<xsl:when test="position() = 1">
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>,</xsl:text>
						</xsl:otherwise>
					</xsl:choose>				
					<xsl:choose>
						<xsl:when test="./pkey-caption">
							<xsl:value-of select="./pkey-caption"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="./pkey-name"/>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:text>=</xsl:text><xsl:value-of select="./pkey-value"/>
				</xsl:for-each>
				<xsl:text> has been </xsl:text>
				<xsl:value-of select="$record-action"/>
				<xsl:choose>
						<xsl:when test="$record-action = 'insert'">
							<xsl:text>ed.</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>d.</xsl:text>
						</xsl:otherwise>
				</xsl:choose>
		</span>
		</center>
		<table border="0" cellspacing="1" class="gridTable" width="100%" style="font-size:12px; font-family:Arial;">
			<xsl:apply-templates select="./history-field"/>
		</table>
		
	</xsl:template>

	<xsl:template match="//history-field">
		<xsl:variable name="record-action" select="../@action"/>
		<xsl:if test="position() = 1">
			<tr class="headerRow">
				<td width="40%">Field:</td>
				<td width="30%">Old value:</td>
				<td width="30%">New value:</td>
			</tr>		
		</xsl:if>
		<tr>
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="position() mod 2">
						<xsl:text>unevenRow</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>evenRow</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<td>
				<xsl:choose>
					<xsl:when test="./@caption">
						<xsl:value-of select="./@caption"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="./@name"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:call-template name="printFieldValue">
					<xsl:with-param name="value" select="./history-value-old"/>
				</xsl:call-template>
			</td>
			<xsl:choose>
				<xsl:when test="$record-action = 'delete'">
					<td> </td>
				</xsl:when>
				<xsl:otherwise>
					<td>
						<xsl:call-template name="printFieldValue">
							<xsl:with-param name="value" select="./history-value-new"/>
						</xsl:call-template>
					</td>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
	</xsl:template>

	<xsl:template name="printFieldValue">
		<xsl:param name="value"/>
		<xsl:choose>
			<xsl:when test="contains($value, '&lt;!--html--&gt;')">
				<!-- memo field with HTML -->
				<xsl:value-of disable-output-escaping="yes" select="$value"/>
			</xsl:when>
			<xsl:otherwise>
				<!-- memo field with plain text and all other fields -->
				<xsl:copy-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
        
	<xsl:template match="//history-unparsed-topic">
		<hr/><pre><xsl:value-of select="./history-unparsed-data"/></pre>
	</xsl:template>

</xsl:stylesheet>

