<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2006-2007 Queplix Corp.
  ~
  ~ Licensed under the Queplix Public License, Version 1.1.1 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
  ~ License for the specific language governing permissions and limitations under
  ~ the License.
  -->

<!-- edited with XML Spy v4.1 U (http://www.xmlspy.com) by yulya (n) -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="yes"/>
	
	<xsl:template match="//history-topic">
		<xsl:apply-templates select="history-header"/>
		<xsl:apply-templates select="history-data/history-field"/>
		<xsl:apply-templates select="ifg-data/ifg"/>
	</xsl:template>
	
	<xsl:template match="//history-header">
		<xsl:text>###### </xsl:text>
		<xsl:value-of select="concat(@user_loginname, ' (', @user_fullname, '): ')"/>
		<xsl:value-of select="@timestamp"/>
		<xsl:text>&#x0A;&#x0A;</xsl:text>
	</xsl:template>
	
	<xsl:template match="//ifg">
			<xsl:text>&#x0A;&#x0A;</xsl:text>
			<xsl:text>------ </xsl:text>
			<xsl:value-of select="./@caption"/>
			<xsl:text>&#x0A;&#x0A;</xsl:text>			
			<xsl:apply-templates select="ifg-record"/>
			
	</xsl:template>
	
	<xsl:template match="//ifg-record">
		<xsl:variable name="record-action" select="./@action"/>
				<xsl:text>The record with </xsl:text>
				<xsl:for-each select="./pkey-field">
					<xsl:choose>
						<xsl:when test="position() = 1">
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>,</xsl:text>
						</xsl:otherwise>
					</xsl:choose>								
					<xsl:choose>
						<xsl:when test="./pkey-caption">
							<xsl:value-of select="./pkey-caption"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="./pkey-name"/>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:text>=</xsl:text><xsl:value-of select="./pkey-value"/>
				</xsl:for-each>
				<xsl:text> has been </xsl:text>
				<xsl:value-of select="$record-action"/>
				<xsl:choose>
						<xsl:when test="$record-action = 'insert'">
							<xsl:text>ed.</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>d.</xsl:text>
						</xsl:otherwise>
				</xsl:choose>
			<xsl:text>&#x0A;&#x0A;</xsl:text>
				
			<xsl:apply-templates select="./history-field"/>
			<xsl:text>&#x0A;&#x0A;</xsl:text>
						
	</xsl:template>

	
	<xsl:template match="//history-field">
		<xsl:variable name="record-action" select="../@action"/>	
		<xsl:choose>
			<xsl:when test="./@caption">
				<xsl:value-of select="./@caption"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="./@name"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>:&#x09;</xsl:text>
		
		<xsl:if test="./history-value-new">
			<xsl:value-of select="./history-value-old"/>
			<xsl:text> ==&gt;&#x0A;</xsl:text>
		</xsl:if>
		<xsl:text>&#x09;&#x09;&#x09;</xsl:text>
		<xsl:choose>
			<xsl:when test="$record-action = 'delete'">
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="./history-value-new"/>
			</xsl:otherwise>
		</xsl:choose>
		
		
		<xsl:text>&#x0A;&#x0A;</xsl:text>
	</xsl:template>
	
	<xsl:template match="//history-unparsed-topic">
		<xsl:value-of select="./history-unparsed-data"/>
	</xsl:template>
</xsl:stylesheet>
