/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.integrator;

import com.queplix.core.modules.config.ejb.CaptionManagerLocal;
import com.queplix.core.modules.config.ejb.ContextMenuConfigManagerLocal;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocal;
import com.queplix.core.modules.config.ejb.FocusConfigManagerLocal;
import com.queplix.core.modules.config.ejb.UserPropertyManagerLocal;
import com.queplix.core.modules.eql.ejb.HistoryLocal;
import com.queplix.core.modules.eql.ejb.LockManagerLocal;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eqlext.ejb.GetRecordsLocal;
import com.queplix.core.modules.eqlext.ejb.SetRecordsLocal;
import com.queplix.core.modules.inbox.ejb.InboxManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

/**
 * Context for all entity operations. Since we can't rely on ServletContex we have to provide some interface to all helpers. Realization
 * of this interface depends on context of usage of entity operations helper. 
 *
 * @author Sergey Kozmin
 * @since 14.03.2007
 */
public interface ActionContext {
    public HistoryLocal getHistoryManager();

    public InboxManagerLocal getInboxManagerLocal();

    public LockManagerLocal getRecordsLockManager();

    public GetRecordsLocal getRecordsManager();

    public SetRecordsLocal getSetRecordsManager();

    public EntityViewConfigManagerLocal getEntityViewConfigManager();

    public CaptionManagerLocal getCaptionManager();

    /**
     * Get UserPropertyManagerEJB local interface.
     * @return UserPropertyManagerLocal object
     */
    public UserPropertyManagerLocal getUserPropertyManager();

    public FocusConfigManagerLocal getFocusConfigManager();

    public ContextMenuConfigManagerLocal getContextMenuManager();

    public JEOManagerLocal getJEOManager();

    public EQLManagerLocal getEQLManager();
}
