/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator.entity;

/**
 * Class that contain dataset parameters
 *
 * @author Sergey Kozmin
 * @since 22.11.2006, 12:02:03
 */
class DatasetDescriptor {
    private DatasetType type;
    /**
     * name of the entity, where dataset is located
     */
    private String locationEntity;
    /**
     * name of the entity which links #locationEntity and #linkedEntity
     */
    private String bindingEntity;
    /**
     * name of the linked entity
     */
    private String linkedEntity;
    /**
     * Primary key field in location entity.
     */
    private String locationPkeyFieldName;
    /**
     * name of the dataset field in entity
     */
    private String locationEntityFieldName;
    /**
     * Foreign key field in binding entity which points to location entity.
     */
    private String bindingEntityFkeyFieldNameToLocation;
    /**
     * Foreign key field in binding entity which points to linked entity.
     */
    private String bindingEntityFkeyFieldNameToLinked;
    /**
     * Primary key field name in linked entity.
     */
    private String linkedEntityPkeyFieldName;
    /**
     * name of the dataset field in linked entity
     */
    private String linkedEntityFieldName;

    /**
     * constructor for m2m or link and new 3.0 in-form-grid datasets
     */
    public DatasetDescriptor(DatasetType type, String locationEntity, String locationPkeyFieldName, String locationEntityFieldName,
                             String bindingEntity, String bindingEntityFkeyFieldNameToLocation, String bindingEntityFkeyFieldNameToLinked,
                             String linkedEntity, String linkedEntityPkeyFieldName, String linkedEntityFieldName, boolean storeInLowerCase) {
        this.type = type;
        this.locationEntity = locationEntity;
        this.bindingEntity = bindingEntity;
        this.linkedEntity = linkedEntity;
        this.locationPkeyFieldName = locationPkeyFieldName;
        this.locationEntityFieldName = locationEntityFieldName;
        this.bindingEntityFkeyFieldNameToLocation = bindingEntityFkeyFieldNameToLocation;
        this.bindingEntityFkeyFieldNameToLinked = bindingEntityFkeyFieldNameToLinked;
        this.linkedEntityPkeyFieldName = linkedEntityPkeyFieldName;
        this.linkedEntityFieldName = linkedEntityFieldName;

        updateCase(storeInLowerCase);
    }

    private void updateCase(boolean storeInLowerCase) {
        if(storeInLowerCase) {
            if(locationEntity != null) {
                locationEntity = locationEntity.toLowerCase();
            }
            if(bindingEntity != null) {
                bindingEntity = bindingEntity.toLowerCase();
            }
            if(linkedEntity != null) {
                linkedEntity = linkedEntity.toLowerCase();
            }
            if(locationPkeyFieldName != null) {
                locationPkeyFieldName = locationPkeyFieldName.toLowerCase();
            }
            if(locationEntityFieldName != null) {
                locationEntityFieldName = locationEntityFieldName.toLowerCase();
            }
            if(bindingEntityFkeyFieldNameToLocation != null) {
                bindingEntityFkeyFieldNameToLocation = bindingEntityFkeyFieldNameToLocation.toLowerCase();
            }
            if(bindingEntityFkeyFieldNameToLinked != null) {
                bindingEntityFkeyFieldNameToLinked = bindingEntityFkeyFieldNameToLinked.toLowerCase();
            }
            if(linkedEntityPkeyFieldName != null) {
                linkedEntityPkeyFieldName = linkedEntityPkeyFieldName.toLowerCase();
            }
            if(linkedEntityFieldName != null) {
                linkedEntityFieldName = linkedEntityFieldName.toLowerCase();
            }
        }
    }

    public String getLocationEntity() {
        return locationEntity;
    }

    public String getLinkedEntity() {
        return linkedEntity;
    }

    public String getBindingEntity() {
        return bindingEntity;
    }

    public String getLocationEntityFieldName() {
        return locationEntityFieldName;
    }

    public DatasetType getType() {
        return type;
    }
    
    public String getLocationPkeyFieldName() {
        return locationPkeyFieldName;
    }

    public String getBindingEntityFkeyFieldNameToLocation() {
        return bindingEntityFkeyFieldNameToLocation;
    }

    public String getBindingEntityFkeyFieldNameToLinked() {
        return bindingEntityFkeyFieldNameToLinked;
    }

    public String getLinkedEntityPkeyFieldName() {
        return linkedEntityPkeyFieldName;
    }

    public String getLinkedEntityFieldName() {
        return linkedEntityFieldName;
    }

    public String toString() {
        return "DatasetDescriptor{" +
                "type=" + type +
                ", locationEntity='" + locationEntity + '\'' +
                ", bindingEntity='" + bindingEntity + '\'' +
                ", linkedEntity='" + linkedEntity + '\'' +
                ", locationPkeyFieldName='" + locationPkeyFieldName + '\'' +
                ", locationEntityFieldName='" + locationEntityFieldName + '\'' +
                ", bindingEntityFkeyFieldNameToLocation='"
                + bindingEntityFkeyFieldNameToLocation + '\'' +
                ", bindingEntityFkeyFieldNameToLinked='"
                + bindingEntityFkeyFieldNameToLinked + '\'' +
                ", linkedEntityPkeyFieldName='" + linkedEntityPkeyFieldName
                + '\'' +
                ", linkedEntityFieldName='" + linkedEntityFieldName + '\'' +
                '}';
    }
}
