/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator.entity;

/**
 * To be thrown when forms description has some inconsistency.
 * For example it can be link to not existing form.
 *
 * @author Sergey Kozmin
 * @since 30.10.2006, 11:46:47
 */
class IncorrectFormDescriptionException extends RuntimeException {
    public IncorrectFormDescriptionException() {
    }

    public IncorrectFormDescriptionException(String message) {
        super(message);
    }

    public IncorrectFormDescriptionException(String message, Throwable cause) {
        super(message, cause);
    }

    public IncorrectFormDescriptionException(Throwable cause) {
        super(cause);
    }
}
