/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator.security;

/**
 * Access level enumeration.
 *
 * @author Kozmin Sergey
 * @since 16.01.2007
 */
public enum AccessLevel {
    READ(0), WRITE(1), OWNER(2), FULL_CONTROL(3);
    
    public final int level;

    AccessLevel(int accessLevelConstant) {
        this.level = accessLevelConstant;
    }

    public static AccessLevel getByLevelConstant(int level) {
        AccessLevel lev = READ;
        switch(level) {
            case 1 : {
                lev = WRITE;
                break;
            }
            case 2 : {
                lev = OWNER;
                break;
            }
            case 3 : {
                lev = FULL_CONTROL;
                break;
            }
        }
        return lev;
    }

    /**
     * If this variable differ from the common values listed below, it means this access level is custom one and used for
     * functional access rights.
     */
    /*private int level;

    public AccessLevel(int level) {
        this.level = level;
    }

    public int getAccessLevelConstant() {
        return level;
    }

    public boolean isStaticAccessLevel() {
        return level == READ || level == WRITE || level == OWNER
                || level == FULL_CONTROL;
    }*/
}