/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator.security;

import com.queplix.core.error.LocalizedAppException;

/**
 * Can't find user exception
 * @author Kozmin Sergey
 * @since 16.01.2007
 */
public class NoSuchUserException extends SecurityException implements LocalizedAppException {
    private Long userID;
    private String userName;
    private String[] messageArgs;

    public NoSuchUserException(Long userID) {
        super("no_such_user_exception2");
        this.userID = userID;
        messageArgs = new String[] {String.valueOf(userID)};
    }

    public NoSuchUserException(String userName) {
        super("no_such_user_exception");
        this.userName = userName;
        messageArgs = new String[] {String.valueOf(userName)};
    }

    public Long getUserID() {
        return userID;
    }

    public String getUserName() {
        return userName;
    }

    /**
     * Get message arguments
     * @return message arguments
     */
    public Object[] getArgs() {
        return messageArgs;
    }
}
