/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator.security;

/**
 * This object describes all possible permission types.
 *
 * @author Sergey Kozmin
 * @since 16.01.2007
 */
public enum PermissionObjectType {
    FOCUS("Focus", 0), SUB_FOCUS("SubFocus", 1), TAB("Tab", 2), FORM("Form", 3), FIELD("Field", 4);

    private String stringRepr;
    public final int intRepr;

    PermissionObjectType(String stringRepr, int intRepr) {
        this.intRepr = intRepr;
        this.stringRepr = stringRepr;
    }

    public String getStringRepr() {
        return stringRepr;
    }

    public static PermissionObjectType getByTypeConstant(int intType) {
        PermissionObjectType type = FIELD;
        switch(intType) {
            case 0 : {
                type = FOCUS;
                break;
            }
            case 1 : {
                type = SUB_FOCUS;
                break;
            }
            case 2 : {
                type = TAB;
                break;
            }
            case 3 : {
                type = FORM;
                break;
            }
        }
        return type;
    }

    public boolean isDirectChildOf(PermissionObjectType type){
        return (this.intRepr == type.intRepr + 1);
    }

    public String toString() {
        return "PermissionObjectType{" +
                "stringRepr='" + stringRepr + '\'' +
                ", intRepr=" + intRepr +
                '}';
    }
}
