/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator.security;

/**
 * This exception is thrown when a session (usually an HTTP session) has expired.
 *
 * @author Kozmin Sergey
 * @since 16.01.2007
 */
public class SessionExpiredException extends RuntimeException {
    private static String hostName;

    static {
        try {
            hostName = java.net.InetAddress.getLocalHost().getHostName();
        } catch (java.net.UnknownHostException uhe) {
            hostName = "<Host Unknown>";
        }
    }

    /**
     * Constructor.
     */
    public SessionExpiredException() {
        super("LogonSession has expired on server: " + hostName);
    }
}
