/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator.security;

/**
 * Work group VO class
 *
 * @author Kozmin Sergey
 * @since 16.01.2007
 */

public class WorkGroup {

    /** Notify method constants */
    public static final int NOTIFY_METHOD_EMPTY = -1;
    public static final int NOTIFY_METHOD_OWNER = 0;
    public static final int NOTIFY_METHOD_ALERT = 1;
    public static final int NOTIFY_METHOD_EMAIL = 2;
    
    private long groupID;
    private String groupName;

    private String email;
    private int notifyMethod;
    
    public WorkGroup(long groupID, String groupName, String email, int notifyMethod) {
        this.groupID = groupID;
        this.groupName = groupName;
        this.email = email;
        this.notifyMethod = notifyMethod;
    }

    public WorkGroup(long groupID, String groupName, String email) {
        this(groupID, groupName, email, NOTIFY_METHOD_EMPTY);
    }
    
    public long getGroupID() {
        return groupID;
    }

    public void setGroupID(long groupID) {
        this.groupID = groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public int getNotifyMethod() {
        return notifyMethod;
    }

    public void setNotifyMethod(int notifyMethod) {
        this.notifyMethod = notifyMethod;
    }

    /**
     * Indicates whether some other object is "equal to" this one.
     *
     * @param obj the reference object with which to compare.
     * @return <code>true</code> if this object is the same as the obj
     *         argument; <code>false</code> otherwise.
     */
    public boolean equals(Object obj) {
        if(obj == this) {
            return true;
        }

        return (obj instanceof WorkGroup) && (((WorkGroup) obj).groupID == groupID);
    }

    /**
     * Returns a hash code value for the object
     *
     * @return a hash code value for this object
     */
    public int hashCode() {
        return (int) groupID;
    }

    /**
     * Get string
     *
     * @return string
     */
    public String toString() {
        return "id=" + groupID + "; name=" + groupName + "; email=" + email +
                "; notifyMethod=" + notifyMethod;
    }
}
