/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.alert;

/**
 * Alert Block data.
 * @see Alert
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:07 $
 */

public final class AlertBlock
    implements java.io.Serializable {

    private long userID;
    private int userType;

    //
    // Constructor.
    //

    public AlertBlock( long _userID, int _userType ) {

        userID = _userID;
        userType = _userType;
    }

    /**
     * User ID getter.
     * @return long
     */
    public long getUserID() {
        return userID;
    }

    /**
     * User Type getter.
     * @return int
     */
    public int getUserType() {
        return userType;
    }

    /*
     * No javadoc
     * @see Object#toString
     */
    public String toString() {
        return "userID=" + userID +
            "; userType=" + userType;
    }

    /*
     * No javadoc
     * @see Object#equals
     */
    public boolean equals( Object obj ) {
        if( obj == this ) {
            return true;
        }
        if( ! ( obj instanceof AlertBlock ) ) {
            return false;
        }

        AlertBlock ab = ( AlertBlock ) obj;
        return ( userID == ab.userID ) && ( userType == ab.userType );
    }

    /*
     * No javadoc
     * @see Object#hashCode
     */
    public int hashCode() {
        return( int ) ( userID | userType << 37 );
    }
}
