/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.alert.eql;

import com.queplix.core.modules.alert.ejb.AlertManagerLocal;
import com.queplix.core.modules.alert.utils.AlertSelectorCriteria;
import com.queplix.core.modules.eql.EQLSession;
import com.queplix.core.modules.eql.error.EQLException;

import java.util.SortedMap;

/**
 * <p>Alert EQL agent class for 'SENT' alerts</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:08 $
 */

public class SentAlertEQLAgent
    extends AlertEQLAgent {

    /*
     * No javadoc
     * @see AlertEQLAgent#callAlertManager
     */
    SortedMap callAlertManager( EQLSession eqlSession,
                                AlertSelectorCriteria criteria )
        throws EQLException {

        // Get outgoing alerts.
        criteria.setIncomming( false );

        // Call AlertManager EJB.
        AlertManagerLocal local = null;
        try {
            local = getAlertManagerLocal( eqlSession );
            return local.getAlerts( criteria );

        } finally {
            try {
                if( local != null ) {
                    local.remove();
                }
            } catch( Exception ex ) {}
        }
    }
}
