/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.alert.utils;

import com.queplix.core.modules.alert.AlertBlock;
import com.queplix.core.utils.dao.InterfaceDAO;

import java.util.Collection;

/**
 * Alert DAO interface
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:08 $
 */

public interface AlertDAO
    extends InterfaceDAO {

    /**
     * Deletes Alert record
     * @param alert AlertVO object
     * @return number of deleted records
     */
    int deleteAlertVO( AlertVO alert );

    /**
     * Blocks Alert record for recipient <code>recipientID</code>
     * @param alert AlertVO object
     * @param block AlertBlock object
     * @return number of created records
     */
    int blockAlertVO( AlertVO alert, AlertBlock block );

    /**
     * Returns new unqie Alert ID
     * @return long
     */
    long getNextAlertID();

    /**
     * Creates new Alert record
     * @param alert AlertVO object
     * @return number of created records
     */
    int storeAlertVO( AlertVO alert );

    /**
     * Updates current Alert record
     * @param alert AlertVO object
     * @return number of updated records
     */
    int updateAlertVO( AlertVO alert );

    /**
     * Load alert VO by its ID
     * @param alertId alert ID
     * @return AlertVO object
     */
    AlertVO loadAlertVO( long alertId );

    /**
     * Load All alert VO
     * @return Collection of AlertVO objects
     */
    Collection loadAllAlertVO();
}
