/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.ejb;

import com.queplix.core.integrator.security.User;
import com.queplix.core.modules.config.utils.UserPropertyID;
import com.queplix.core.modules.config.utils.DialogSetting;

import javax.ejb.EJBObject;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Collection;

/**
 * UserPropertyManager EJB remote interface.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:15 $
 */
public interface UserPropertyManager extends EJBObject {

    public String getUserProperty(String propId, User user) throws RemoteException;
    public Map getAllUserProperties(User user) throws RemoteException;
    public UserPropertyID setUserProperty(String propId, String value, User user) throws RemoteException;
    public UserPropertyID deleteUserProperty(String propId, User user) throws RemoteException;

    public String[] getFieldsForGrid(User user, String entity) throws RemoteException;
    public UserPropertyID setFieldsForGrid(User user, String entity, String[] fields) throws RemoteException;

    public void deleteDialogUISettings(User user) throws RemoteException;
    public void updateDialogUISettings(User user, DialogSetting settingsToSave) throws RemoteException;
    public void resetDialogUISettings(User user, Collection<DialogSetting> settingsToSave) throws RemoteException;
    public Collection<DialogSetting> loadDialogsUISettings(User user) throws RemoteException;
}
