/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.update.impl;

import com.queplix.core.modules.config.utils.SysPropertyManager;
import com.queplix.core.modules.eql.EQLResCell;
import com.queplix.core.modules.eql.update.EntityUpdate;

/**
 * System properties update business logic.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:15 $
 */
public class SysPropUpdate
    extends EntityUpdate {

    /* (non-Javadoc)
     * @see EntityUpdate#afterUpdate()
     */
    public void afterUpdate() {
        removeFromCache();
    }

    /* (non-Javadoc)
     * @see EntityUpdate#afterDelete()
     */
    public void afterDelete() {
        removeFromCache();
    }

    /**
     * Removes current record from the cache.
     */
    protected void removeFromCache() {

        if( isNew() ) {
            return;
        }

        EQLResCell idCell = getCell( "prop_id" );
        String propID = idCell.getString();

        // Remove property from the Cache.
        SysPropertyManager.flushCache( propID );

        DEBUG( "System property '" + propID + "' removed from the cache" );
    }

}
