/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils;

import com.queplix.core.modules.config.jxb.ContextMenu;
import com.queplix.core.utils.dao.InterfaceDAO;

/**
 * Context menu config DAO.
 * @author [MVT] Michael Trofimov
 * @version $Revision$ $Date$
 */
public interface ContextMenuConfigDAO extends InterfaceDAO {
	
    /**
     * Delete ContextMenu objects.
     * @return number of updated records
     */
    int clearContextMenusVO();

    /**
     * Store ContextMenu objects
     * @param contextMenus Array of ContextMenu objects
     * @return number of updated records
     */
    int storeContextMenusVO(ContextMenu[] contextMenus);

    /**
     * Load ContextMenu objects
     * @return Array of ContextMenu objects
     */
    ContextMenu[] loadContextMenusVO();

}
