/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils;

import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.utils.dao.InterfaceDAO;

import java.util.Collection;

/**
 * Entity View Config DAO.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:16 $1
 */

public interface EntityViewConfigDAO
    extends InterfaceDAO {

    /**
     * Delete all Entity objects.
     * @return number of updated records
     */
    int clearAllEntityVO();

    /**
     * Delete Entity object.
     * @param entityName Entity name attribute
     * @return number of updated records
     */
    int clearEntityVO( String entityName );

    /**
     * Store Entity object
     * @param entity Entity object
     * @return number of updated records
     */
    int storeEntityVO( Entity entity );

    /**
     * Stores History information for the Entity object
     * @param entity Entity object
     */
    void storeHistoryVO( Entity entity );

    /**
     * Load Entity object
     * @param entityName Entity name attribute
     * @return Entity object
     */
    Entity loadEntityVO( String entityName );

    /**
     * Load all Entity objects
     * @return collection of Entity objects
     */
    Collection loadAllEntityVO();
}
