/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils;

import com.queplix.core.modules.config.jxb.LocalizedObject;
import com.queplix.core.modules.config.jxb.LocalizedObjectsId;
import com.queplix.core.utils.dao.InterfaceDAO;

/**
 * Localization data access object.
 * @author Michael Trofimov
 */
public interface LocalizationDAO extends InterfaceDAO {

    /**
     * Loads collections of localized objects.
     * @param objectsId    Identifies collections of localized objects.
     * @return Collection of localized obejcts.
     */
    <T extends LocalizedObject> T[] loadLocalizedObjects(
            LocalizedObjectsId objectsId, Class<T> targetType);


    /**
     * Stores collections of localized objects.
     * @param objectsId  Identifies collections of localized objects.
     * @param obejcts   Collection of localized objects.
     * @return Number of updated records.
     */
    <T extends LocalizedObject> int saveLocalizedObjects(LocalizedObjectsId objectsId, T[] objects);

    /**
     * Deletes localized objects.
     * @param objectsId        Identifies collections of localized objects.
     * @return Number of deleted records.
     */
    int deleteLocalizedObjects(LocalizedObjectsId objectsId);

}
