/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils;

/**
 * <p>UserProperty compound key</p>
 * @author [DAG] Dmitry Gaponenko
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:17 $
 */

public class UserPropertyID
    implements java.io.Serializable, Comparable {

    // =============================================================== Fields

    private String id;
    private long userId;
    private int userAuthenticationType;

    // =============================================================== Initialization

    public UserPropertyID( String id, long userId, int userAuthenticationType ) {
        this.id = id;
        this.userId = userId;
        this.userAuthenticationType = userAuthenticationType;
    }

    // =============================================================== Inherited methods

    /*(non-Javadoc)
     * @see Comparable#compareTo()
     */
    public int compareTo( Object o ) {

        if( o == this ) {
            return 0;
        }

        UserPropertyID up = ( UserPropertyID ) o;
        if( id.equals( up.id ) ) {
            if( userId == up.userId ) {
                return userAuthenticationType > up.userAuthenticationType ? 1 : ( userAuthenticationType == up.userAuthenticationType) ? 0 : -1;
            } else {
                return userId > up.userId ? 1 : -1;
            }
        } else {
            return id.compareTo( up.id );
        }
    }

    /*(non-Javadoc)
     * @see Object#hashCode()
     */
    public int hashCode() {
        return( int ) ( id.hashCode() | userId | ( userAuthenticationType << 37 ) );
    }

    /*(non-Javadoc)
     * @see Object#equals(Object)
     */
    public boolean equals( Object other ) {

        if( other == null || ! ( other instanceof UserPropertyID ) ) {
            return false;
        }

        UserPropertyID up = ( UserPropertyID ) other;
        return id.equals( up.id ) &&
            userId == up.userId &&
            userAuthenticationType == up.userAuthenticationType;
    }

    /*(non-Javadoc)
     * @see Object#toString()
     */
    public String toString() {
        return "id=" + id + ", userID=" + userId + ", userAuthenticationType=" + userAuthenticationType;
    }

    // =============================================================== Access methods

    public String getId() {
        return id;
    }

    public long getUserId() {
        return userId;
    }

    public int getUserAuthenticationType() {
        return userAuthenticationType;
    }
}
