/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils;

import com.queplix.core.integrator.security.PermissionObjectType;

/**
 * Permission object VO
 *
 * @author Sergey Kozmin
 * @since 24.01.2007
 */
public class ViewObject {
    public static enum ObjectStatus {
        EXISTING, TO_BE_INSERTED, TO_BE_DELETED
    }

    private Long id;
    private String name;
    private Long parent;
    /**
     * if parent is not initialized(status == TO_BE_INSERTED), then use this object to know it.
     */
    private ViewObject parentObject;

    private int orderInGroup;
    private PermissionObjectType type;
    private ObjectStatus status;
    private String icon;
    private boolean inFrameLinks = false;
    private boolean grid = true;

    public ViewObject(Long id, String name, Long parent, int orderInGroup, PermissionObjectType type, ObjectStatus status, ViewObject parentObject, String icon, boolean inFrameLinks, boolean grid) {
        this(id, name, parent, orderInGroup, type, status, parentObject, icon, inFrameLinks);
        this.grid = grid;
    }

    public ViewObject(Long id, String name, Long parent, int orderInGroup, PermissionObjectType type, ObjectStatus status, ViewObject parentObject, String icon, boolean inFrameLinks) {
        this(id, name, parent, orderInGroup, type, status, parentObject, icon);
        this.inFrameLinks = inFrameLinks;
    }

    public ViewObject(Long id, String name, Long parent, int orderInGroup, PermissionObjectType type, ObjectStatus status, ViewObject parentObject, String icon) {
        this.parentObject = parentObject;
        this.icon = icon;
        this.orderInGroup = orderInGroup;
        this.status = status;
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.type = type;
    }

    public ViewObject(Long id, String name, Long parent, int orderInGroup, PermissionObjectType type, ObjectStatus status) {
        this.orderInGroup = orderInGroup;
        this.status = status;
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.type = type;
    }

    public ViewObject(Long id, String name, Long parent, PermissionObjectType type) {
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.type = type;
        status = ObjectStatus.EXISTING;
        orderInGroup = 0;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getParent() {
        return parent;
    }

    public void setParent(Long parent) {
        this.parent = parent;
    }

    public PermissionObjectType getType() {
        return type;
    }

    public void setType(PermissionObjectType type) {
        this.type = type;
    }

    public ObjectStatus getStatus() {
        return status;
    }

    public void setStatus(ObjectStatus status) {
        this.status = status;
    }

    public int getOrderInGroup() {
        return orderInGroup;
    }

    public void setOrderInGroup(int orderInGroup) {
        this.orderInGroup = orderInGroup;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean getInFrameLinks() {
        return inFrameLinks;
    }

    public void setInFrameLinks(boolean inFrameLinks) {
        this.inFrameLinks = inFrameLinks;
    }

    public boolean getGrid() {
        return grid;
    }

    public void setGrid(boolean grid) {
        this.grid = grid;
    }

    public ViewObject getParentObject() {
        return parentObject;
    }

    public String toString() {
        return "ViewObject{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", parent=" + parent +
                ", parentObject=" + parentObject +
                ", orderInGroup=" + orderInGroup +
                ", type=" + type +
                ", status=" + status +
                ", icon='" + icon + '\'' +
                ", inFrameLinks='" + inFrameLinks + '\'' +
                ", grid='" + grid + '\'' +
                '}';
    }
}
