/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.config.utils;

import com.queplix.core.modules.config.jxb.Focus;
import com.queplix.core.modules.config.jxb.Form;
import com.queplix.core.modules.config.jxb.Tab;
import com.queplix.core.utils.dao.InterfaceDAO;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * View objects DAO.
 * @author Kozmin Sergey
 * @since 2007.01.24
 */

public interface ViewObjectsDAO extends InterfaceDAO {
    /**
     * Delete all the objects with the given view_object from the permissions table and view_objects table
     * @param toBeDeleted view_objects to be deleted
     */
    public void deleteObjects(ViewObjectsStructure toBeDeleted);

    /**
     * Create new and or update existing objects
     * @param toUpdate updating objects
     */
    public void updateObjects(ViewObjectsStructure toUpdate);

    /**
     * Loads all view object from the system.
     * @return list of {@link ViewObject} objects
     */
    public ViewObjectsStructure loadViewObjects();

    /**
     * Saves all the form values, that is not supported by view_objects
     * @param updatingStructure updating structure
     */
    public void updateExternalFormValues(Map<ViewObject, Form> updatingStructure);
    
    /**
     * Saves all non-standard values from Tabs
     * @param list of Tab instances
     */
    public void updateExternalTabValues(List<Tab> tabs);
    

    /**
     * Load Focus object
     * @param focusName Focus name attribute
     * @return Focus object
     */
    Focus loadFocusVO( String focusName );

    /**
     * Load all Focus objects
     * @return collection of Focus objects
     */
    Collection<Focus> loadAllFocusVO();
}
