/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import com.queplix.core.jxb.entity.types.SqlSType;
import com.queplix.core.utils.StringHelper;

/**
 * <p>EQL Memo object</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLMemoObject
    extends EQLObject
    implements java.io.Serializable {

    private char[] value;

    public EQLMemoObject( char[] value ) {
        this.value = value;
    }

    public char[] getValue() {
        return value;
    }

    public Object getObject() {
        return value;
    }

    public int getSqlType() {
        return SqlSType.MEMO_TYPE;
    }

    public String toString() {
        if( value != null ) {
            return String.valueOf( value );
        } else {
            return StringHelper.EMPTY_VALUE;
        }
    }

    // ----------------------------------------------------------------- specials

    // Check is HTML string
    public boolean isHTML() {
        return StringHelper.isHTML( value );
    }

    // Get string as Plain Text
    public String toPlainText() {
        String s = toString();
        if( isHTML() ) {
            // html -> text
            return StringHelper.html2text( s );
        } else {
            return s;
        }
    }

    // Get string as HTML
    public String toHTML() {
        String s = toString();
        if( !isHTML() ) {
            // text -> html
            return StringHelper.text2html( s );
        } else {
            return s;
        }
    }
}
