/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;

/**
 * <p>EQL Request Field object</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLReqField
    implements java.io.Serializable {

    private EQLReqEntity reqEntity;
    private Efield field;

    public EQLReqField( EQLReqEntity reqEntity, Efield field ) {
        this.reqEntity = reqEntity;
        this.field = field;
    }

    public EQLReqField( Entity entity, Efield field ) {
        this.reqEntity = new EQLReqEntity( entity );
        this.field = field;
    }

    public EQLReqEntity getReqEntity() {
        return reqEntity;
    }

    public Efield getField() {
        return field;
    }

    public int hashCode() {
        return reqEntity.hashCode() | field.hashCode();
    }

    public boolean equals( Object o ) {
        if( o == null )
            return false;

        if( o == this )
            return true;

        if( o instanceof EQLReqField ) {
            EQLReqField reqField = ( EQLReqField ) o;

            return field.getName().equals( reqField.getField().getName() ) &&
                reqEntity.equals( reqField.getReqEntity() );
        }

        return false;
    }

    public String toString() {
        return "reqEntity=[" + reqEntity + "] field=" + field.getName();
    }
}
