/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import java.util.ArrayList;

/**
 * <p>EQL Request From Clause object</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLReqFrom
    implements java.io.Serializable {

    private ArrayList fromEntities;
    private ArrayList joinEntities;

    public EQLReqFrom() {
        this.fromEntities = new ArrayList();
        this.joinEntities = new ArrayList();
    }

    public void addFromEntity( EQLReqEntity fromEntity ) {
        fromEntities.add( fromEntity );
    }

    public void addJoinEntity( EQLReqJoin join ) {
        joinEntities.add( join );
    }

    public ArrayList getFromEntities() {
        return fromEntities;
    }

    public ArrayList getJoinEntities() {
        return joinEntities;
    }

    public boolean contains( EQLReqEntity fromEntity ) {
        return fromEntities.contains( fromEntity );
    }

    public boolean contains( EQLReqJoin join ) {
        return joinEntities.contains( join );
    }

    public EQLReqEntity getFromEntity( int i ) {
        return( EQLReqEntity ) fromEntities.get( i );
    }

    public int fromSize() {
        return fromEntities.size();
    }

    public EQLReqJoin getJoinEntity( int i ) {
        return( EQLReqJoin ) joinEntities.get( i );
    }

    public int joinSize() {
        return joinEntities.size();
    }
}