/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import java.util.ArrayList;

/**
 * <p>EQL Request Select Clause object</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLReqSelect
    implements java.io.Serializable {

    private ArrayList attrs;
    private ArrayList ids;
    private boolean isDistinct;

    public EQLReqSelect() {
        attrs = new ArrayList();
        ids = new ArrayList();
        isDistinct = false;
    }

    public ArrayList getAttrs() {
        return attrs;
    }

    public EQLReqSelectAttr getAttr( int i ) {
        return( EQLReqSelectAttr ) attrs.get( i );
    }

    public EQLReqSelectAttr getAttr( String id ) {
        int i = ids.indexOf( id );
        return getAttr( i );
    }

    public int getPos( String id ) {
        return ids.indexOf( id );
    }

    public void setIsDistinct( boolean isDistinct ) {
        this.isDistinct = isDistinct;
    }

    public boolean isDistinct() {
        return isDistinct;
    }

    public int size() {
        return attrs.size();
    }

    public void addAttr( EQLReqSelectAttr attr ) {

        if( !attr.getReqField().getField().getSelectable().booleanValue() ) {
            // field isn't selectable
            throw new IllegalStateException( "Field '" + attr.getReqField().getField().getId() +
                                             "' isn't selectable..." );
        }

        attrs.add( attr );
        ids.add( attr.getId() );
    }
}
