/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import com.queplix.core.modules.eql.error.EQLException;

import java.util.ArrayList;

/**
 * <p>Abstract EQL Sub Operation Member Enumeration class</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public final class EQLReqSubOpMemberEnum
    implements EQLReqSubOpMember, java.io.Serializable {

    private ArrayList parameters;

    public EQLReqSubOpMemberEnum() {
        parameters = new ArrayList();
    }

    public void addParameter( EQLObject param )
        throws EQLException {
        parameters.add( param );
    }

    public int getSize() {
        return parameters.size();
    }

    public EQLObject getParameter( int i ) {
        return( EQLObject ) parameters.get( i );
    }

    public ArrayList getParameters() {
        return parameters;
    }

    public int hashCode() {
        return parameters.hashCode();
    }

    public boolean equals( Object o ) {
        if( ! ( o instanceof EQLReqSubOpMemberEnum ) )
            return false;

        if( o == this )
            return true;

        EQLReqSubOpMemberEnum member = ( EQLReqSubOpMemberEnum ) o;
        return parameters.equals( member.getParameters() );
    }

    public String toString() {
        return "(" + parameters + ")";
    }
}