/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.parser.EQLInterpreter;

import java.util.ArrayList;

/**
 * <p>Abstract EQL Sub Operation Member Function class</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:21 $
 */

public abstract class EQLReqSubOpMemberFunc
    implements EQLReqFunc, EQLReqSubOpMember, java.io.Serializable {

    protected EQLInterpreter eqlInt;
    private ArrayList parameters;

    public EQLReqSubOpMemberFunc() {
        parameters = new ArrayList();
    }

    public void addParameter( EQLReqOp param )
        throws EQLException {
        parameters.add( param );
    }

    public int getSize() {
        return parameters.size();
    }

    public EQLReqOp getParameter( int i ) {
        return( EQLReqOp ) parameters.get( i );
    }

    public ArrayList getParameters() {
        return parameters;
    }

    public void setEQLInt( EQLInterpreter eqlInt ) {
        this.eqlInt = eqlInt;
    }

    public int hashCode() {
        return parameters.hashCode() | getClass().hashCode();
    }

    public boolean equals( Object o ) {
        if( ! ( o instanceof EQLReqSubOpMemberFunc ) )
            return false;

        if( o == this )
            return true;

        EQLReqSubOpMemberFunc member = ( EQLReqSubOpMemberFunc ) o;
        return parameters.equals( member.getParameters() ) &&
            getClass().getName().equals( member.getClass().getName() );
    }

    public String toString() {
        return getClass().getName() + "(" + parameters + ")";
    }
}