/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql;

/**
 * <p>EQL Request Sub Order By object</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:21 $
 */

public class EQLReqSubOrder
    implements java.io.Serializable {

    // All order operation ids
    public static final int ASC_OP = 1;
    public static final int DESC_OP = 2;

    private int op;
    private EQLReqOp reqOp;
    private boolean mandatory;

    public EQLReqSubOrder( int op, EQLReqOp reqOp, boolean mandatory ) {
        this.op = op;
        this.reqOp = reqOp;
        this.mandatory = mandatory;
    }

    public EQLReqOp getReqOp() {
        return reqOp;
    }

    public int getOperation() {
        return op;
    }

    public boolean isMandatory() {
        return mandatory;
    }
}
