/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.error;

import com.queplix.core.error.GenericSystemException;

/**
 * Base EQL system exception.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:25 $
 */

public class EQLSystemException
    extends GenericSystemException {

    /**
     * Creates a new EQL exception.
     * @param msg error message
     */
    public EQLSystemException( String msg ) {
        super( msg );
    }

    /**
     * Creates a new EQL exception.
     * @param t Throwable object
     */
    public EQLSystemException( Throwable t ) {
        super( t );
    }

    /**
     * Creates a new EQL exception.
     *
     * @param msg error message
     * @param t Throwable object
     */
    public EQLSystemException( String msg, Throwable t ) {
        super( msg, t );
    }

}