/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.parser;

import com.queplix.core.modules.config.utils.EntitySchema;
import com.queplix.core.modules.eql.EQLERes;
import com.queplix.core.modules.eql.EQLReq;
import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.EQLResRecord;
import com.queplix.core.modules.eql.EQLSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.jxb.eqlagent.Property;

/**
 * <p>Defines EQL agent interface</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:26 $
 */

public interface EQLAgent
    extends java.io.Serializable {

    /**
     * Init schema
     * @param schema entity schema
     * @param properties array of Property objects
     */
    void init( EntitySchema schema, Property[] properties );

    /**
     * Get current entity schema
     * @return EntitySchema object
     */
    EntitySchema getEntitySchema();

    /**
     * Calculate number of records in response.
     * @param eqlSession EQL session
     * @param res EQLRes object
     * @return int
     * @throws EQLException
     */
    int doCount( EQLSession eqlSession, EQLRes res )
        throws EQLException;

    /**
     * Do select query
     * @param eqlSession EQL session
     * @param req EQL request
     * @return EQL response
     * @throws EQLException
     */
    EQLRes doSelect( EQLSession eqlSession, EQLReq req )
        throws EQLException;

    /**
     * Do update query
     * @param eqlSession EQL session
     * @param res EQL response
     * @param resRecord EQL record to update
     * @return number of updated records
     * @throws EQLException
     */
    int doUpdate( EQLSession eqlSession, EQLERes res, EQLResRecord resRecord )
        throws EQLException;

    /**
     * Do delete query
     * @param eqlSession EQL session
     * @param res EQL response
     * @param resRecord EQL record to update
     * @return number of deleted records
     * @throws EQLException
     */
    int doDelete( EQLSession eqlSession, EQLERes res, EQLResRecord resRecord )
        throws EQLException;
}