/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.parser;

import com.queplix.core.modules.eql.EQLReqSubOpMember;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * <p>EQL interpreter prepared statement</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:27 $
 */

public final class EQLIntPreparedStatement
    implements java.io.Serializable {

    // ----------------------------------------------------- variables

    // map of parameters
    protected Map params = new HashMap();

    // current cursor position
    private int cursor_pos = 1;

    // ----------------------------------------------------- public overrided methods

    /**
     * Sets the designated parameter to the given EQL <code>EQLReqSubOpMember</code> value.
     * @param parameterIndex the first parameter is 1, the second is 2, ...
     * @param x the parameter value
     * @throws EQLException
     */
    public void setObject( int parameterIndex, EQLReqSubOpMember x ) {
        if( parameterIndex <= 0 )
            throw new IllegalArgumentException( "parameter index should be greater than 0" );

        if( cursor_pos > 1 )
            throw new IllegalStateException( "current cursor position already set" );

        params.put( new Integer( parameterIndex ), x );
    }

    /**
     * Reset prepared statement
     * @return himself
     */
    public EQLIntPreparedStatement reset() {
        cursor_pos = 1;
        return this;
    }

    /**
     * Get next sub operation member
     * @return current EQLReqSubOpMember object
     */
    public EQLReqSubOpMember next() {
        Object o = params.get( new Integer( cursor_pos ) );
        cursor_pos++;
        return( EQLReqSubOpMember ) o;
    }

    /**
     * Get string
     * @return string
     */
    public String toString() {

        if( !params.isEmpty() ) {
            StringBuffer sb = new StringBuffer();
            sb.append( "{" );
            for( Iterator it = params.keySet().iterator(); it.hasNext(); ) {
                Integer pos = ( Integer ) it.next();
                Object param = params.get( pos );
                sb.append( pos ).append( "=" ).append( param.toString() );
                sb.append( " [" ).append( param.getClass().getName() ).append( "]\n" );
            }
            sb.append( "}" );
            return sb.toString();
        } else {
            return "{}";
        }
    }
}
