/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.parser;

import com.queplix.core.modules.eql.EQLReq;
import com.queplix.core.modules.eql.EQLReqMetaData;
import com.queplix.core.modules.eql.error.EQLException;

/**
 * <p>EQL interpreter abstract class</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:27 $
 */

public abstract class EQLInterpreter
    extends EQLPluggableModule {

    /**
     * Build EQL request tree
     * @param eqlQuery EQL request string
     * @return EQLReq object
     * @throws EQLException
     */
    public abstract EQLReq build( String eqlQuery )
        throws EQLException;

    /**
     * Set EQLIntPreparedStatement object
     * @param eqlPS EQLIntPreparedStatement object
     */
    public abstract void setPreparedStatement( EQLIntPreparedStatement eqlPS );

    /**
     * Get EQLIntPreparedStatement object
     * @return EQLIntPreparedStatement object
     */
    public abstract EQLIntPreparedStatement getPreparedStatement();

    /**
     * Set EQL request meta data
     * @param eqlMeta meta data
     */
    public abstract void setEQLReqMetaData( EQLReqMetaData eqlMeta );

    /**
     * Get EQL request meta data
     * @return meta data
     */
    public abstract EQLReqMetaData getEQLReqMetaData();
}