/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.parser;

import com.queplix.core.modules.eql.EQLERes;
import com.queplix.core.modules.eql.EQLResRecord;
import com.queplix.core.modules.eql.EQLSql;
import com.queplix.core.modules.eql.error.EQLException;

/**
 * <p>Update SQL builder abstract class</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:28 $
 */

public abstract class SQLUpdateBuilder
    extends SQLBuilder {

// ------------------ PUBLIC METHODS -----------------------

    /**
     * Build insert Sql query
     * @param res EQLERes object
     * @param resRecord EQLResRecord current record
     * @return new EQLSql object
     * @throws EQLException
     */
    public final EQLSql buildInsertSql( EQLERes res, EQLResRecord resRecord )
        throws EQLException {

        // set sql and sql parameters
        eqlSql.setMainSql( getInsertSql( res, resRecord ) );
        eqlSql.setSqlParameters( getSqlParameters() );

        return eqlSql;
    }

    /**
     * Build update Sql query
     * @param res EQLERes object
     * @param resRecord EQLResRecord current record
     * @return new EQLSql object
     * @throws EQLException
     */
    public final EQLSql buildUpdateSql( EQLERes res, EQLResRecord resRecord )
        throws EQLException {

        // set sql and sql parameters
        eqlSql.setMainSql( getUpdateSql( res, resRecord ) );
        eqlSql.setSqlParameters( getSqlParameters() );

        return eqlSql;
    }

    /**
     * Build delete Sql query
     * @param res EQLERes object
     * @param resRecord EQLResRecord current record
     * @return new EQLSql object
     * @throws EQLException
     */
    public final EQLSql buildDeleteSql( EQLERes res, EQLResRecord resRecord )
        throws EQLException {

        // set sql and sql parameters
        eqlSql.setMainSql( getDeleteSql( res, resRecord ) );
        eqlSql.setSqlParameters( getSqlParameters() );

        return eqlSql;
    }

// -------------- PROTECTED ABSTRACT METHODS ---------------

    /**
     * Get insert Sql query
     * @param res EQLERes object
     * @param resRecord EQLResRecord current record
     * @return Sql query as string or null
     * @throws EQLException
     */
    protected abstract String getInsertSql( EQLERes res, EQLResRecord resRecord )
        throws EQLException;

    /**
     * Get update Sql query
     * @param res EQLERes object
     * @param resRecord EQLResRecord current record
     * @return Sql query as string or null
     * @throws EQLException
     */
    protected abstract String getUpdateSql( EQLERes res, EQLResRecord resRecord )
        throws EQLException;

    /**
     * Get delete Sql query
     * @param res EQLERes object
     * @param resRecord EQLResRecord current record
     * @return Sql query as string or null
     * @throws EQLException
     */
    protected abstract String getDeleteSql( EQLERes res, EQLResRecord resRecord )
        throws EQLException;

}
