/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eql.parser.generic;

import com.queplix.core.modules.eql.EQLReq;
import com.queplix.core.modules.eql.EQLReqMetaData;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.parser.EQLIntPreparedStatement;
import com.queplix.core.modules.eql.parser.EQLInterpreter;

/**
 * <p>EQL interpreter abstract class</p>
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:28 $
 */

public abstract class AbstractEQLInterpreter
    extends EQLInterpreter
    implements InterfaceEQLRequestBuilder, Cloneable {

    // ------------------------------------------------------- variables

    private EQLIntMediator mainMediator;
    private EQLIntPreparedStatement eqlPS;

    // ------------------------------------------------------- constructor

    AbstractEQLInterpreter() {
        mainMediator = new EQLIntMediator( this );
    }

    // ------------------------------------------------------- Abstract methods

    /**
     * Clone EQL interpreter
     * @return new instance of interpreter
     */
    public abstract Object clone();

    /**
     * Return true if cloned
     * @return clone flag
     */
    public abstract boolean isCloned();

    // ------------------------------------------------------- EQLInterpreter methods

    /* (non-Javadoc)
     * @see EQLInterpreter
     */
    public void setPreparedStatement( EQLIntPreparedStatement _eqlPS ) {
        eqlPS = _eqlPS;
    }

    /* (non-Javadoc)
     * @see EQLInterpreter
     */
    public EQLIntPreparedStatement getPreparedStatement() {
        return eqlPS;
    }

    /* (non-Javadoc)
     * @see EQLInterpreter
     */
    public EQLReqMetaData getEQLReqMetaData() {
        return mainMediator.getEQLReq().getMetaData();
    }

    /* (non-Javadoc)
     * @see EQLInterpreter
     */
    public void setEQLReqMetaData( EQLReqMetaData eqlMeta ) {
        mainMediator.getEQLReq().setMetaData( eqlMeta );
    }

    /* (non-Javadoc)
     * @see EQLInterpreter
     */
    public EQLReq build( String eqlQuery )
        throws EQLException {
        mainMediator.parse( eqlQuery );
        return mainMediator.getEQLReq();
    }

    // ------------------------------------------------------- public methods

    /**
     * Get main mediator of EQL interpreter
     * @return EQLIntMediator object
     */
    public EQLIntMediator getMainMediator() {
        return mainMediator;
    }
}