/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.actions;

import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.error.UserQueryParseException;
import com.queplix.core.modules.eqlext.jxb.gr.Reqs;

/**
 * <p>New Get Records Action</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:37 $
 */

public class NewGRAction
    extends EntityGRAction {

    // ----------------------------------------------------- getters

    protected void buildEQL()
        throws UserQueryParseException {
    // do nothing
    }

    // ----------------------------------------------------- protected methods

    /*
     * No javadoc
     * @see AbstractGRAction#init
     */
    protected void init( Reqs reqs ) {
        super.init( reqs );
        this.ignoreSendOnRequest = true;
    }

    /*
     * No javadoc
     * @see AbstractGRAction#callEQLManager
     */
    protected EQLRes callEQLManager()
        throws EQLException {
        // execute EQl query
        return ctx.getEQLManager().selectNew( ctx.getSC(), entity );
    }

    /*
     * No javadoc
     * @see AbstractGRAction#createResRecords
     */
    protected int callEQLManagerForCount() {
        return 1;
    }
}
