/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.actions.filters;

import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.config.utils.EntityHelper;
import com.queplix.core.modules.eql.EQLReqField;
import com.queplix.core.modules.eql.EQLResCell;
import com.queplix.core.modules.eql.EQLResRecord;
import com.queplix.core.modules.eqlext.actions.EntityGRAction;

/**
 * EQL ext request filter.
 * Filters <code>Reqs</code> object before processing to EQLManager.
 * @author [ALB] Baranov L. Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:37 $
 */
public abstract class EntityGRFilter
    extends EntityGRAction {

	//
    // Gets EQL response cell by field name.
    //
    protected final EQLResCell getResCell( EQLResRecord resRecord, Entity entity, String fieldName ) {
        Efield efield = EntityHelper.getEfield( fieldName, entity );
        EQLReqField reqField = new EQLReqField( entity, efield );
        return resRecord.getResCell( reqField );
    }
}