/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.transforms.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.eqlext.error.EfieldTransformException;
import com.queplix.core.modules.eqlext.transforms.EfieldTransform;

/**
 * <p>Default Float transform class</p>
 * @author [ALB] Baranov L. Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:39 $
 */

public class FloatTransform
    extends EfieldTransform {

    public Object toObject( LogonSession ls, Entity entity, Efield field, String value )
        throws EfieldTransformException {
        try {
            return new Float( value );
        } catch( NumberFormatException ex ) {
            throw new EfieldTransformException( ex.getMessage(), ex );
        }
    }

    public String toString( LogonSession ls, Entity entity, Efield field, Object o ) {
        return o.toString();
    }
}