/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.transforms.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.jxb.entity.types.SqlSType;
import com.queplix.core.modules.eqlext.error.EfieldTransformException;
import com.queplix.core.utils.StringHelper;

import java.text.ParseException;
import java.util.StringTokenizer;

/**
 * Transformer for interval fields in the calls entity
 * 
 * @author Ladnev Ilya
 * @version $Revision: 1.2 $ $Date: 2006/10/10 04:29:59 $
 */
public class IntervalTransform extends TimeTransform {

	
    /*
     * (non-Javadoc)
     * 
     * @see TimeTransform#toObject(EfieldTransformObject, String)
     */
    public Object toObject(LogonSession ls, Entity entity, Efield field, String s)
        throws EfieldTransformException {

        int sqlType = field.getSqltype().getType();
        int secs;
        if ( sqlType == SqlSType.LONG_TYPE ) {
            StringTokenizer st = new StringTokenizer(s, ":");
            String sTokens[] = new String[4];
            for( int i = 0; i < 4; i++) {
                if (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ( ! StringHelper.isEmpty (token)) {
                        sTokens[i] = token;
                    } else {
                        sTokens[i] = "0";
                    }
                }
                else {
                    sTokens[i] = "0";
                }
                DEBUG("AZ: token[" + i + "] = " + sTokens[i]);
            }
            
            Integer days = new Integer(0);
            Integer hrs = new Integer(0);
            Integer mins = new Integer(0);
            Integer sec = new Integer(0);
            try { 
                for (int i=0; i < 4; i ++) {
                    if (sTokens[i].endsWith("d")) {
                        days = StringHelper.str2integer(sTokens[i]);
                    } else if (sTokens[i].endsWith("h")) {
                        hrs = StringHelper.str2integer(sTokens[i]);
                    } else if (sTokens[i].endsWith("m")) {
                        mins = StringHelper.str2integer(sTokens[i]);
                    } else if (sTokens[i].endsWith("s")) {
                        sec = StringHelper.str2integer(sTokens[i]);
                    }
                }       
                secs = days.intValue() * 86400 + hrs.intValue()*3600 + mins.intValue()*60 + sec.intValue();
                if (secs == 0) {
                    throw new EfieldTransformException("");
                }
                return new Long(secs);
     
            } catch (ParseException e) {
                throw new EfieldTransformException(e.getMessage(), e);
            }         
        } else {
            throw new EfieldTransformException(
                    "Unsupported sql type '" + sqlType + "' for time field");
        }   
    }
    
    /*
	 * (non-Javadoc)
	 * 
	 * @see TimeTransform#toString(EfieldTransformObject, Object)
	 */
	public String toString(LogonSession ls, Entity entity, Efield field, Object o)
	    throws EfieldTransformException {

		int sqlType = field.getSqltype().getType();
		String sTime = "";
		if ( sqlType == SqlSType.LONG_TYPE ) {
			long time = ( ( Number ) o ).longValue();
            if (time == 0) return "";
            long days = time / (60 * 60 * 24);
            time = time - (60 * 60 * 24 * days);
            long hours = time / (60 * 60);
            time = time - (60 * 60 * hours);
            long mins = time / (60);
            time = time - (60 * mins);
            long secs = time;
            sTime =  days + "d:" + hours + "h:" + mins + "m:" + secs + "s";
		} else {
            throw new EfieldTransformException(
                    "Unsupported sql type '" + sqlType + "' for time field");
        }   

        return sTime;
	}
}
