/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.update.impl;

import com.queplix.core.modules.eql.EQLResRecord;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.eqlext.error.FileManagerException;
import com.queplix.core.modules.eqlext.utils.FileManager;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.jeo.gen.UploadFolderObject;
import com.queplix.core.modules.jeo.gen.UploadFolderObjectHandler;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.StringHelper;

import java.io.File;

/**
 * Ulpoad folder update business logic.
 *
 * @author [DBR] Daniel B. Raskin
 * @author [ALB] Baranov Andrey
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:40 $
 */
public class UploadFolderUpdate
    extends EntityUpdate {

    // ========================================================== Update handler

    /* (non-Javadoc)
     * @see EntityUpdate#beforeUpdate()
     */
    public int beforeUpdate()
        throws EQLException {

        // Get the new directory name.
        EQLResRecord record = getEUO().getRecord();
        String dirName = record.getResCell( 1 ).getString();

        // Check for spaces.
        dirName = StringHelper.trim( dirName );
        if( dirName == null ) {
            throw new EQLException( "Directory name must have non-space characters" );
        }

        // Create or rename directory.
        if( record.isNew() ) {
            if( !FileManager.createDirectory( dirName ) ) {
                return SKIP_RECORD;
            }

        } else {
            String oldDirName = ( String ) record.getResCell( 1 ).getOldEQLObject().getObject();
            if( !FileManager.renameDirectory( oldDirName, dirName ) ) {
                return SKIP_RECORD;
            }
        }

        // Check the I/O operation result.
        File dir = FileManager.getDirectory( dirName );
        if( dir == null ) {
            throw new FileManagerException( "Can't find new directory '" + dirName + "'." );
        }
        record.getResCell( 1 ).setString( FileManager.getLocalName( dir ) );

        return CONTINUE;
    }

    // ========================================================== Update handler

    /* (non-Javadoc)
     * @see EntityUpdate#delete()
     */
    public int delete()
        throws EQLException {

        // Initialization.
        LogonSession ls = getEUO().getSession().getLogonSession();
        EQLResRecord record = getEUO().getRecord();
        JEOManagerLocal jeoManager = ( JEOManagerLocal ) getCOM().
            getLocalObject( JNDINames.JEOManager, JEOManagerLocalHome.class );

        // Get the directory object ID.
        long folderID = ( ( Long ) record.getEQLObject( 0 ).getObject() ).longValue();

        // Get the directory name.
        JEObjectHandler hnd = ( JEObjectHandler ) UploadFolderObjectHandler.
            selectByFolderID( jeoManager, ls, folderID );
        if( hnd == null ) {
            throw new FileManagerException( "Looks like the directories and database are not synchronized." );
        }

        String dirName = ( ( UploadFolderObject ) hnd.getJEObject() ).getFolder();
        FileManager.deleteDirectory( dirName );

        return CONTINUE;
    }

}
