/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.modules.eqlext.utils;

import com.queplix.core.integrator.ActionContext;
import com.queplix.core.modules.eql.ejb.HistoryLocal;
import com.queplix.core.modules.eql.ejb.LockManagerLocal;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eql.ejb.HistoryLocalHome;
import com.queplix.core.modules.eql.ejb.LockManagerLocalHome;
import com.queplix.core.modules.eql.ejb.EQLManagerLocalHome;
import com.queplix.core.modules.inbox.ejb.InboxManagerLocal;
import com.queplix.core.modules.inbox.ejb.InboxManagerLocalHome;
import com.queplix.core.modules.eqlext.ejb.GetRecordsLocal;
import com.queplix.core.modules.eqlext.ejb.SetRecordsLocal;
import com.queplix.core.modules.eqlext.ejb.GetRecordsLocalHome;
import com.queplix.core.modules.eqlext.ejb.SetRecordsLocalHome;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocal;
import com.queplix.core.modules.config.ejb.CaptionManagerLocal;
import com.queplix.core.modules.config.ejb.UserPropertyManagerLocal;
import com.queplix.core.modules.config.ejb.FocusConfigManagerLocal;
import com.queplix.core.modules.config.ejb.ContextMenuConfigManagerLocal;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocalHome;
import com.queplix.core.modules.config.ejb.CaptionManagerLocalHome;
import com.queplix.core.modules.config.ejb.UserPropertyManagerLocalHome;
import com.queplix.core.modules.config.ejb.FocusConfigManagerLocalHome;
import com.queplix.core.modules.config.ejb.ContextMenuConfigManagerLocalHome;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.utils.ejb.AbstractSessionEJB;
import com.queplix.core.utils.JNDINames;

/**
 * Implements {@link com.queplix.core.integrator.ActionContext} interface, that is based on ejb context cache.
 *
 * @author Sergey Kozmin
 * @since 15.03.2007
 */
public class EJBCacheActionContext implements ActionContext {
    private AbstractSessionEJB ejbSession;

    public EJBCacheActionContext(AbstractSessionEJB baseEJB) {
        if(baseEJB == null) {
            throw new IllegalArgumentException("Couldn't work with null object ejb session. ");
        }
        this.ejbSession = baseEJB;
    }

    public HistoryLocal getHistoryManager() {
        return (HistoryLocal) ejbSession.getLocalObject(JNDINames.History, HistoryLocalHome.class);
    }

    public InboxManagerLocal getInboxManagerLocal() {
        return (InboxManagerLocal) ejbSession.getLocalObject(JNDINames.InboxManager, InboxManagerLocalHome.class);
    }

    public LockManagerLocal getRecordsLockManager() {
        return (LockManagerLocal) ejbSession.getLocalObject(JNDINames.LockManager, LockManagerLocalHome.class);
    }

    public GetRecordsLocal getRecordsManager() {
        return (GetRecordsLocal) ejbSession.getLocalObject(JNDINames.GetRecords, GetRecordsLocalHome.class);
    }

    public SetRecordsLocal getSetRecordsManager() {
        return (SetRecordsLocal) ejbSession.getLocalObject(JNDINames.SetRecords, SetRecordsLocalHome.class);
    }

    public EntityViewConfigManagerLocal getEntityViewConfigManager() {
        return (EntityViewConfigManagerLocal) ejbSession.getLocalObject(JNDINames.EntityViewConfigManager,
                EntityViewConfigManagerLocalHome.class);
    }

    public CaptionManagerLocal getCaptionManager() {
        return (CaptionManagerLocal) ejbSession.getLocalObject(JNDINames.CaptionManager,
                CaptionManagerLocalHome.class);
    }

    public UserPropertyManagerLocal getUserPropertyManager() {
        return (UserPropertyManagerLocal) ejbSession.getLocalObject(JNDINames.UserPropertyManager,
                UserPropertyManagerLocalHome.class);
    }

    public FocusConfigManagerLocal getFocusConfigManager() {
        return (FocusConfigManagerLocal) ejbSession.getLocalObject(JNDINames.FocusConfigManager,
                FocusConfigManagerLocalHome.class);
    }

    public ContextMenuConfigManagerLocal getContextMenuManager() {
        return (ContextMenuConfigManagerLocal) ejbSession.getLocalObject(JNDINames.ContextMenuConfigManager,
                ContextMenuConfigManagerLocalHome.class);
    }

    public JEOManagerLocal getJEOManager() {
        return (JEOManagerLocal) ejbSession.getLocalObject(JNDINames.JEOManager,
                JEOManagerLocalHome.class);
    }

    public EQLManagerLocal getEQLManager() {
        return (EQLManagerLocal) ejbSession.getLocalObject(JNDINames.EQLManager,
                EQLManagerLocalHome.class);
    }
}
