/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.utils;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.eql.EQLMemoObject;
import com.queplix.core.modules.eql.EQLNullObject;
import com.queplix.core.modules.eql.EQLObject;
import com.queplix.core.modules.eql.EQLStringObject;
import com.queplix.core.modules.eqlext.error.EfieldTransformException;
import com.queplix.core.modules.eqlext.transforms.EfieldTransform;
import com.queplix.core.modules.eqlext.transforms.EfieldTransformFactory;
import com.queplix.core.utils.StringHelper;

/**
 * <p>Field Converter</p>
 * <p>Converts EQL object to string to show on user browser and back</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:41 $
 */

public final class FieldConverter {

    private FieldConverter() {}

    /**
     * Convert user string object to EQL object
     * @param ls user logon session
     * @param entity Entity object
     * @param field Efield object
     * @param s given string
     * @return EQL object
     * @throws EfieldTransformException
     */
    public static EQLObject string2EQLObject( LogonSession ls,
                                              Entity entity,
                                              Efield field,
                                              String s )
        throws EfieldTransformException {

        //
        // convert string to Java object
        //
        Object javaObj;

        EfieldTransform et = EfieldTransformFactory.getEfieldTransform( field );
        if( s != null && et != null ) {
            // make transform
            javaObj = et.toObject( ls, entity, field, s );

        } else {
            javaObj = s;
        }

        //
        // convert Java object to EQL object
        //
        return EQLObject.getInstance( javaObj );
    }

    /**
     * Convert EQL object to user string object
     * @param ls user logon session
     * @param entity Entity object
     * @param field Efield object
     * @param eqlObj given object
     * @return user string
     * @throws EfieldTransformException
     */
    public static String EQLObject2String( LogonSession ls,
                                           Entity entity,
                                           Efield field,
                                           EQLObject eqlObj )
        throws EfieldTransformException {

        // null object?
        if( eqlObj instanceof EQLNullObject ) {
            return eqlObj.toString();
        }

        EfieldTransform et = EfieldTransformFactory.getEfieldTransform( field );
        if( et != null ) {
            return et.toString( ls, entity, field, eqlObj.getObject() );
        }

        if( eqlObj instanceof EQLStringObject ) {
            return StringHelper.clear( eqlObj.toString() );
        } else if( eqlObj instanceof EQLMemoObject ) {
            return StringHelper.clear( eqlObj.toString() );
        } else {
            return eqlObj.toString();
        }
    }
}
