/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.utils;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eqlext.jxb.gr.Report;
import com.queplix.core.utils.StringHelper;

/**
 * Report callback handler event class (@see ReportCallbackHnd).
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:42 $
 */

public final class ReportCallbackHndEvent
    implements java.io.Serializable {

    // ----------------------------------------------------- variables

    private final LogonSession ls;
    private final Report report;
    private final String transletName;

    private volatile int reqId = StringHelper.EMPTY_NUMBER;
    private volatile int reqSize;

    private volatile int iterId;
    private volatile int page;
    private volatile boolean isLast;

    // ----------------------------------------------------- constructor

    public ReportCallbackHndEvent( LogonSession ls,
                                   Report report,
                                   String transletName ) {
        this.ls = ls;
        this.report = report;
        this.transletName = transletName;
    }

    // ----------------------------------------------------- getters

    public LogonSession getLogonSession() {
        return ls;
    }

    public Report getReport() {
        return report;
    }

    public String getTransletName() {
        return transletName;
    }

    public int getReqId() {
        return reqId;
    }

    public int getReqSize() {
        return reqSize;
    }

    public int getIterId() {
        return iterId;
    }

    public int getPage() {
        return page;
    }

    public boolean isLast() {
        return isLast;
    }

    // ----------------------------------------------------- setters

    public void setNewReq( int reqId, int reqSize ) {
        this.reqId = reqId;
        this.reqSize = reqSize;
    }

    public void setIterId( int iterId ) {
        this.iterId = iterId;
    }

    public void setPage( int page ) {
        this.page = page;
    }

    public void setLast( boolean isLast ) {
        this.isLast = isLast;
    }
}
