/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.eqlext.utils;

import com.queplix.core.utils.dao.AbstractPropertyFactory;

import java.io.InputStream;
import java.util.Properties;

/**
 * <p>Factory class for working with report transelts classes</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.2 $ $Date: 2005/10/26 14:03:51 $
 */

public class ReportTransletFactory
    implements java.io.Serializable {

// ----------------------- VARIABLES -----------------------

    private static final String FILE_NAME = "report.properties";
    private static final Class CLASS = ReportTransletFactory.class;

    private static Properties props;

    // load optional properties
    static {
        try {
            InputStream is = AbstractPropertyFactory.loadSysPropertiesAsStream( CLASS, FILE_NAME );
            props = new Properties();
            props.load( is );

        } catch( Exception ex ) {
            props = null;
            ex.printStackTrace();
        }
    }

    // Default translet name.
    private final static String DEF_TRANSLET_NAME = "report";

// --------------------- PUBLIC METHODS --------------------

    //
    // Get property
    //
    public static String getProperty( String name ) {
        return props.getProperty( name );
    }

    /**
     * Get translet class name
     * @param name translet name
     * @return String
     */
    public static String getTransletClassName( String name ) {
        return getProperty( name );
    }

    /**
     * Get default translet class name
     * @return String
     */
    public static String getDefTransletClassName() {
        return getTransletClassName( DEF_TRANSLET_NAME );
    }

// ------------------- PRIVATE METHODS ---------------------

    /**
     * Constructor
     */
    private ReportTransletFactory() {}
}
