/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.modules.inbox.update.impl;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.jeo.gen.*;
import com.queplix.core.utils.JNDINames;

/**
 * Inbox records update handler.
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public class InboxUpdate extends EntityUpdate {

    // ---------------------------------------------------- Before update handler

    public int beforeUpdate() throws EQLException {

        long time = System.currentTimeMillis();

        // Initialization.
        JEOManagerLocal jeoMgr = (JEOManagerLocal)getCOM().getLocalObject(JNDINames.JEOManager, JEOManagerLocalHome.class);

        if (!isNew()) {
            // .. just for new records
            return CONTINUE;
        }

        // Get current record ID.
        JEObjectHandler inboxHnd = getJEOHandler(jeoMgr, InboxObjectHandler.class);
        InboxObject inboxObj = (InboxObject)inboxHnd.getJEObject();
        if (inboxObj.getPkey() == null) {
            throw new NullPointerException("Inbox record ID is NULL");
        }

        //
        // Checking for default owner and workgroup.
        //
        if (inboxObj.getRecipient_id() != null || inboxObj.getWorkgroup_id() != null) {
            // .. owner -or- workgroup already set - skip update proc
            return CONTINUE;
        }

        // try to set owner or workgroup
        if (inboxObj.getAccount_id() != null) {
            AccountObject account = AccountObjectHandler.selectByPkey(jeoMgr, getLogonSession(), inboxObj.getAccount_id().longValue());
            if (account == null)
                throw new NullPointerException("Account record wasn'r found. The account id is " + inboxObj.getAccount_id().longValue());

            if (account.getOwner_id() != null) {
                inboxObj.setRecipient_id(account.getOwner_id());
            } else if (account.getWorkgroup_id() != null) {
                inboxObj.setWorkgroup_id(account.getWorkgroup_id());
            } else {
                throw new NullPointerException("The message owner wasn't set.");
            } // if (account.getOwner_id() != null)
        } // if (inboxObj.getAccount_id() != null)

        INFO("InboxUpdate#beforeUpdate finished for message #" + inboxObj.getPkey() + ".");
        INFO("Time (ms) - " + (System.currentTimeMillis() - time ));

        return CONTINUE;

    } // beforeUpdate()

    // ---------------------------------------------------- delete handler

    public int delete()
        throws EQLException {

        long time = System.currentTimeMillis();

        // Initialization.
        JEOManagerLocal jeoMgr = (JEOManagerLocal) getCOM().
            getLocalObject(JNDINames.JEOManager, JEOManagerLocalHome.class);

        // Get current record ID.
        JEObjectHandler inboxHnd = getJEOHandler(jeoMgr, InboxObjectHandler.class);
        InboxObject inboxObj = (InboxObject)inboxHnd.getJEObject();
        if (inboxObj.getPkey() == null) {
            throw new NullPointerException("Inbox record ID is NULL");
        }
        inboxObj.setDelete_flag(new Integer(1));
        inboxHnd.commit();

        INFO("InboxUpdate#beforeUpdate finished for message #" + inboxObj.getPkey() + ".");
        INFO("Time (ms) - " + (System.currentTimeMillis() - time ));

        return SKIP_RECORD;

    } // delete()

} // end of class
