/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.modules.inbox.utils;

import com.queplix.core.modules.inbox.ejb.InboxManagerLocal;
import com.queplix.core.modules.inbox.ejb.InboxManagerLocalHome;
import com.queplix.core.modules.inbox.ejb.InboxManager;
import com.queplix.core.modules.inbox.ejb.InboxManagerHome;
import com.queplix.core.modules.inbox.utils.log.AbstractInboxLogPublisher;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.AccessRightsManager;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;

/**
 * The abstract mail filter class.
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public abstract class AbstractMailFilter extends AbstractInboxPluggableModule implements MailFilter {

    /** Add-on MailFilter publisher */
    protected final AbstractInboxLogPublisher inboxPublisher = createInboxLogPublisher();

    /**
     * Creates new instance of InboxLogPublisher.
     * @return AbstractInboxLogPublisher
     */
    protected abstract AbstractInboxLogPublisher createInboxLogPublisher();

    /**
     * Get logon session
     * @return LogonSession logon session
     */
    protected LogonSession getLogonSession() {
        return AccessRightsManager.getSystemLogonSession();
    }

    /**
     * InboxManagerLocal getter.
     * @return InboxManagerLocal
     */
    protected InboxManagerLocal getInboxManager() {

        CacheObjectManager com = new CacheObjectManager();
        return (InboxManagerLocal)com.getLocalObject(JNDINames.InboxManager, InboxManagerLocalHome.class);
    } // getInboxManager() : InboxManagerLocal

    /**
     * Makes log ID (needed to distinguish logs of plenty messages)
     *
     * @param messageID message ID
     * @return log ID
     */
    protected String makeLogID( Long messageID ) {
        return "[" + messageID + "] ";
    }
} // abstract class AbstractMailFilter extends AbstractInboxPluggableModule implements MailFilter
