/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.modules.inbox.utils;

import com.queplix.core.utils.dao.InterfaceDAO;

import java.util.Collection;
import java.util.Date;

/**
 * Description.
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public interface AccountDAO
    extends InterfaceDAO {

    /**
     * Load account VO by ID
     * @param accountID long
     * @return AccountVO object
     */
    AccountVO loadAccountVO( long accountID );

    /**
     * Load ALL account VO.
     * @return Collection of AccountVO objects
     */
    Collection loadAllAccountVO();

    /**
     * Load ALL active account VO where Account.nextCheckDate less than <code>nextCheckDate</code>.
     * @param nextCheckDate Date
     * @return Collection of AccountVO objects
     */
    Collection loadAllActiveAccountVO( Date nextCheckDate );

    /**
     * Load account's valid state.
     * @param account AccountVO
     * @return Boolean
     */
    Boolean loadValidFlag( AccountVO account );

    /**
     * Load account's last receive date.
     * @param account AccountVO
     * @return Date
     */
    Date loadLastReceiveDate( AccountVO account );

    /**
     * Store current mailbox valid state flag.
     * @param account AccountVO
     * @param b Boolean
     */
    void storeValidFlag( AccountVO account, Boolean b );

    /**
     * Store last message receive date.
     * @param account AccountVO
     * @param d Date
     * @param messageUID message id
     * @param messageDigest message digest string
     */
    void storeLastReceiveDate(AccountVO account, Date d, String messageUID, String messageDigest);

    /**
     * Store last message ID.
     * @param account AccountVO
     * @param messageUID message id
     * @param messageDigest message digest string
     */
    void storeLastMessageID(AccountVO account, String messageUID, String messageDigest);

    /**
     * Store account next check date.
     * @param account AccountVO
     * @param d Date
     */
    void storeNextCheckDate( AccountVO account, Date d );
}
