/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.inbox.utils;

import com.queplix.core.modules.inbox.error.InvalidAccountException;

import javax.mail.Message;
import javax.mail.MessagingException;
import java.util.Date;

/**
 * Inbox Provider Interface
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.2 $ $Date: 2006/01/24 20:30:20 $
 */

public interface InboxProvider
    extends InboxPluggableModule, java.io.Serializable {

    // ----------------------------------------------------- setters/getters

    String getJavaMailProto();

    // ----------------------------------------------------- public methods

    /**
     * Mark message as "deleted".
     * @param message Message
     * @throws MessagingException
     */
    void setDeletedMsgFlag( Message message )
        throws MessagingException;

    /**
     * Mark message as "seen".
     * @param message Message
     * @throws MessagingException
     */
    void setSeenMsgFlag( Message message )
        throws MessagingException;

    /**
     * Get message UID (unique JavaMail message ID).
     * @param message Message
     * @return String or NULL
     * @throws MessagingException
     */
    String getUID( Message message )
        throws MessagingException;

    /**
     * Gets message arrival to server date.
     * @param message Message
     * @return system date
     * @throws MessagingException
     */
    Date getServerDate( Message message )
        throws MessagingException;

    /**
     * Checks mail account.
     * @throws InvalidAccountException if account is invalid
     */
    void checkAccount()
        throws InvalidAccountException;

    /**
     * Opens connection.
     * @throws MessagingException
     */
    void open()
        throws MessagingException;

    /**
     * Closes active connection.
     * @param expunge expunges all deleted messages if this flag is true
     */
    void close( boolean expunge );

    /**
     * Returns Message ResultSet
     * @param filter MessageFilter (optional)
     * @return ResultSet
     * @throws MessagingException
     */
    ResultSet getResultSet( MessageFilter filter )
        throws MessagingException;

    /**
     * Returns Message by its UID.
     * @param uid String
     * @return Message or NULL
     * @throws MessagingException
     */
    Message getMessage( String uid )
        throws MessagingException;
}
