/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.inbox.utils.db;

import com.queplix.core.utils.dao.DBRealm;

/**
 * Special class to work with DB DAO realization.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1 $ $Date: 2006/01/20 15:19:10 $
 */
public final class DBRealmManager {

    // Private constructor - blocks instantiation. /
    private DBRealmManager() {}

    // ================================================================= DB realm singleton

    private static final DBRealm dbRealm = new DBRealm( "inbox.db.properties" );

    // ================================================================= Methods

    public static String getSql( String name ) {
        return dbRealm.getSql( name );
    }
}
