/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.inbox.utils.log;

import com.queplix.core.modules.inbox.InboxMessage;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.services.utils.log.Level;
import com.queplix.core.modules.services.utils.log.impl.BaseLogRecord;

/**
 * Abstract inbox LOG record value object.
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.1 $ $Date: 2006/01/20 15:19:10 $
 */

public abstract class AbstractInboxLogRecord
    extends BaseLogRecord {

    // ------------------------------------------------------- Variables

    private InboxMessage im;
    private Long accountId;

    // ------------------------------------------------------- Constructors

    AbstractInboxLogRecord( LogonSession ls,
                            Level level,
                            String message,
                            long process_id,
                            InboxMessage im ) {

        super( ls, level, message, process_id );
        this.im = im;
    }

    AbstractInboxLogRecord( LogonSession ls,
                            Level level,
                            String message,
                            long process_id,
                            Long accountId ) {

        super( ls, level, message, process_id );
        this.accountId = accountId;
    }

    // ------------------------------------------------------- Getters

    public final InboxMessage getInboxMailMessage() {
        return im;
    }

    public final Long getAccountId() {
        if( im != null ) {
            throw new IllegalStateException();
        }
        return accountId;
    }

    // ------------------------------------------------------- Public overrided methods

    /*
     * No javadoc
     * @see AbstractLogRecord#getHndClassName
     */
    public String getHndClassName() {
        return "com.queplix.core.modules.inbox.utils.log.EmailLogHandler";
    }
}
